﻿using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Text.RegularExpressions;
using DataAccess;

/// <summary>
/// Summary description for CPatient
/// </summary>
public class CPatient
{
    protected BaseMaster m_BaseMstr { get; set; }
    
    public CPatient(BaseMaster BaseMstr)
	{
        m_BaseMstr = BaseMstr;
	}

    public DataSet GetPatientIDRS(long lFXUserID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID, m_BaseMstr.ClientIP, m_BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vKey", m_BaseMstr.Key);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_PATIENT.getPatientIDRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }

    }

    public long GetPatientGender()
    {
        string str = null;
        str = m_BaseMstr.PatientGender;
        str.Trim();
        str.ToUpper();

        long n = 0;
        if (str == "M")
        {
            n = 1;
        }
        else if (str == "F")
        {
            n = 0;
        }
        else
        {
            n = -1;
        }

        return n;
    }

    public long GetPatientAge()
    {
        long lAge = m_BaseMstr.PatientAge;
        return lAge;
    }

    public double GetPatientHeight()
    {
        long lInches = m_BaseMstr.PatientHeight;
        double dMeters = lInches * 0.0254;
        return dMeters;
    }

    public double GetPatientWeight()
    {
        long lPounds = m_BaseMstr.PatientWeight;
        double dKilos = lPounds * 0.453592;
        return dKilos;
    }
}
